<?php if ( post_password_required() ) return; ?>

<div id="comments" class="comments-area">
    <?php if ( have_comments() ): /*comment list*/ ?>
        <h5 class="comments-title"><?php
            if(get_comments_number() != 1){
                esc_html_e( 'Comments', 'goto' );
            }else{
                esc_html_e( 'Comment', 'goto' );
            }
        ?></h5>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ):/*comment navigation*/ ?>
            <nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'goto' ); ?></h2>
                <div class="cmt-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'goto' )); ?></div>
                <div class="cmt-next"><?php next_comments_link( esc_html__( 'Newer Comments ', 'goto' )); ?></div>
            </nav>
        <?php endif; ?>

        <div class="comment-list">
            <?php
                wp_list_comments(
                    array(
                        'callback' => 'goto_comment_list'
                    )
                );
            ?>
        </div>

    <?php endif; ?>
    
    <?php if ( ! comments_open() ): /*comment disable*/ ?>
        <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'goto' ); ?></p>
    <?php
        /*comment form*/
        else:
            $commenter = wp_get_current_commenter();

            $fields = array(
                'email' =>
                    '<div class="cmt-field cmt-input"><label>'. esc_html__( 'E-mail *:', 'goto' ) .'</label><input id="email" type="email" name="email" value="' . esc_attr(  $commenter['comment_author_email'] )  . '" required></div>',
                'author' =>
                    '<div class="cmt-field cmt-input"><label>'. esc_html__( 'Name *:', 'goto' ) .'</label><input id="author" type="text" name="author" value="' . esc_attr( $commenter['comment_author'] ).'" required></div>'
            );

            $args = array(
                'title_reply_before' => '<h5 id="reply-title" class="comment-reply-title">',
                'title_reply' => esc_html__( 'Leave a reply', 'goto'),
                'title_reply_after' => '</h5>',
                'fields' => apply_filters( 'comment_form_default_fields', $fields ),
                'comment_field' => '<div class="cmt-field cmt-textarea"><label>'. esc_html__( 'Comment:', 'goto' ) .'</label><textarea id="comment" name="comment" required>' . '</textarea></div>',
                'label_submit' => esc_html__( 'Post Comment', 'goto'),
            );

            comment_form( $args );

            /*remove novalidate on form */
            wp_add_inline_script(
                'goto-custom-script',
                "document.addEventListener( 'DOMContentLoaded', function(){
                    var cmtForm = document.getElementById( 'commentform' );

                    if( ! cmtForm ) return;
                    
                    cmtForm.removeAttribute( 'novalidate' );
                } );",
                'after'
            );
        endif;
    ?>
</div>